module jpeg2ppm

import StdFile, StdMisc, StdBool, StdList, StdString, StdDebug
import jpeg, ppm

Start world
	# (opened,input,world)		= sfopen "test.jpg" FReadData world
	| not opened				= abort "could not open input file"
	# (opened, output, world)	= fopen "out.ppm" FWriteData world
	| not opened				= abort "could not open output file"
	# bytes						= fileToCharList input	
	# bytes						= imageToPPM (JPEGDecode1 bytes)
	# output					= charListToFile bytes output
	=							fclose output world

fileToCharList :: File -> [Char]
fileToCharList file
	# (success, c, file)	= sfreadc file
	| success				= [c : fileToCharList file]
							= []

charListToFile :: [Char] *File -> *File
charListToFile [c : cs] file
	= charListToFile cs (fwritec c file)
charListToFile [] file
	= file
